implementation module _SystemDynamic

import StdFile
import StdEnv
from StdBool import not
import StdArray
import StdDynamicTypes

// import RWSDebug

import StdDynamicLowLevelInterface
import DynamicLinkerInterface
import DynamicUtilities
// --------------------------------------------------------------------------------------------------------------------------			

:: DynamicTemp = E.a: {
		value	:: a					// do not change order see boxing of arguments in gts_copy.c
	,	type	:: T_ypeObjectType
	}

// Type of a dynamic (internal, change also convertDynamic.icl,overloading.icl, conversion-functions)
// ----------------------------------------------------------------------------------------------------------------------
:: T_ypeObjectType
	= T_ypeConsSymbol !T_ypeName !T_ypeID [T_ypeObjectType]
	| PV_Placeholder (T_ypeObjectType -> T_ypeObjectType) T_ypeObjectType
	| UPV_Placeholder (T_ypeObjectType -> T_ypeObjectType) T_ypeObjectType
	| UV_Placeholder (T_ypeObjectType -> T_ypeObjectType) T_ypeObjectType
	
:: T_ypeName	:== {#Char}		

:: T_ypeID
	// internal dynamic
	= ModuleID DummyModuleID				// within application
	
	// external dynamic
	| RunTimeID !Int				//	id (both encoded/decoded dynamic rts)
	| LazyRunTimeID !Int !Int 		// id {dynamic_index (both rt and disk)} {disk library instance w.r.t. main dynamic}


_coerce :: !T_ypeObjectType !T_ypeObjectType -> (Bool, [T_ypeObjectType])
_coerce type1 type2
	= _common_unify type1 type2 True

_unify :: !T_ypeObjectType !T_ypeObjectType -> (Bool, [T_ypeObjectType])
_unify type1 type2 
	= _common_unify type1 type2 False
	
_common_unify :: !T_ypeObjectType !T_ypeObjectType !Bool -> (!Bool, ![T_ypeObjectType])
_common_unify type1 type2 coerce
	#! (ok,ind,type_refs)
		= _unify2 type1 type2 [] []
	| not ok
		= (False,ind)
		
		#! equivalent_type_definitions
			= CheckTypeDefinitions type_refs;			
		| equivalent_type_definitions
			= (True,ind)
			= (False,ind)
where
	_unify2 :: !T_ypeObjectType !T_ypeObjectType ![T_ypeObjectType] ![TypeReference] -> (!Bool,![T_ypeObjectType],![TypeReference])
	_unify2 (T_ypeConsSymbol type_name1 type_id1 type_args1) (T_ypeConsSymbol type_name2 type_id2 type_args2) indirection_list type_refs
		# (equal,type_refs)
			= compare_type_name (type_name1,type_id1) (type_name2,type_id2) type_refs
		| equal
			= _unify_args type_args1 type_args2 indirection_list type_refs
			= (False,indirection_list,type_refs)
	where
		_unify_args [] [] indirection_list type_refs
			= (True,indirection_list,type_refs)
		_unify_args [t1:t1s] [t2:t2s] indirection_list type_refs
			# (ok,indirection_list,type_refs)
				= _unify2 t1 t2 indirection_list type_refs
			| ok
				= _unify_args t1s t2s indirection_list type_refs
				
				= (False,indirection_list, type_refs)
		_unify_args _ _ indirection_list type_refs
			= (False,indirection_list,type_refs)
			
	_unify2 tp=:(T_ypeConsSymbol type_name1 _ type_args1) var=:(PV_Placeholder _ _) indirection_list type_refs
		#! indirection_list
			= if coerce indirection_list (_subst_variable  tp var indirection_list)
		= (True,indirection_list,type_refs)

	// 1st T_ypeConsSymbol, 2nd PV_Placeholder, overwrite PV_Placeholder (2nd arg) with type (1st arg)
	_subst_variable :: T_ypeObjectType T_ypeObjectType [T_ypeObjectType] -> ![T_ypeObjectType]
	_subst_variable _ _  _
		= code inline {						|| list | PV_Placeholder | T_ypeConsSymbol2
			fill_a 0 1						|| list | T_ypeConsSymbol1 | T_ypeConsSymbol2
			push_a 2						|| list | T_ypeConsSymbol1 | T_ypeConsSymbol2 | list
			push_a 2						|| list | T_ypeConsSymbol1 | T_ypeConsSymbol2 | list | T_ypeConsSymbol1
			fill _Cons 2 _hnf 5				|| list | T_ypeConsSymbol1 | T_ypeConsSymbol2 | list | T_ypeConsSymbol1
			pop_a 3
		}

_undo_indirections :: a ![T_ypeObjectType] -> a
_undo_indirections  x list = code {
	.o 2 0												||  list | x
	:_undo_indirections
	||		print "_undo_indirections\n"
			push_a 1									||  list | x | list			
	:_undo_indirection_loop
			eq_desc _Nil 0 0
			jmp_true _end_undo_indirection_loop			||  list | x | Nil
			eq_desc _Cons 2 0
			jmp_true _undo_this_indirection				||  list | x | Cons T Next
			buildAC "StdDynamics: Unknown Descriptor in indirectionlist"
			jmp _maRCo_abort
	
	:_undo_this_indirection								||  list | x | Cons T next
			push_arg 0 2 1								||  list | x | Cons T next | T
			
			push_a 0									||  list | x | Cons T next | T | T
			push_a 1									||  list | x | Cons T next | T | T | T
			fill e__SystemDynamic_dPV_Placeholder 2 _hnf 2	||  list | x | Cons T next | PV_Placeholder T T
			
			push_arg 1 2 2								||  list | x | Cons T next | PV_Placeholder T T | next
			update_a 0 2								||  list | x | next        | PV_Placeholder T T | next
	.keep 1 2
			pop_a 2										||  list | x | next
			jmp _undo_indirection_loop
	
	:_end_undo_indirection_loop							||  list | x | Nil
			update_a 1 2								||  x | x | Nil
			pop_a 2										||  x
			jsr_eval 0
	.d 1 0
			rtn
			
	||=================
	||   abort call
	||=================
	:_maRCo_abort
			jsr_eval	0
			jmp e_StdMisc_sabort
}

// --------------------------------------------------------------------------------------------------------------------------			
init_dynamic :: !String !DynamicHeader !*a -> *(.Bool,.GlobalDynamicInfoDummy,*a) | BinaryDynamicIO a
init_dynamic file_name dynamic_header=:{block_table_i,graph_i} file
	// a block table
	#! (ok,block_table,file)
		= read_block_table_from_dynamic dynamic_header file
	#! n_blocks
		= size block_table
	| not ok
		= (False,undef,file)
		
	// read graph blocks
	#! (ok,graph_blocks,file)
		= read_graph_blocks 0 n_blocks (createArray n_blocks "hallo") block_table dynamic_header file
	| not ok
		= (False,undef,file)
		
	// create global dynamic info
	#! gdi
		= { GlobalDynamicInfo |
			file_name		= file_name
		,	first_time		= True	
			
		,	block_table		= block_table
		,	id				= 0
		,	graph_blocks	= graph_blocks
		,	graph_pointers	= { {} \\ i <- [1..n_blocks] }
		
		,	diskid_to_runtimeid = {}
		,	di_disk_to_rt_dynamic_indices	= {}
		
		, 	di_dummy		= {}
		,	di_type_redirection_table		= {}

		}
	= (True,{gdid=gdi},file)
where 
	read_graph_blocks :: !Int !Int !*{String} !BlockTable !DynamicHeader !*f -> (!Bool,!{String},!*f) | BinaryDynamicIO f
	read_graph_blocks block_i n_blocks graph_blocks block_table dynamic_header=:{graph_i} file
		| block_i == n_blocks
			= (True,graph_blocks,file)

		#! block
			= block_table.[block_i]

		// read graph block
		#! (ok,file)
			= bd_seek file (block.bk_offset + graph_i) FSeekSet
		#! (graph_block,file)
			= bd_reads file block.bk_size
		| not ok || (size graph_block <> block.bk_size)
			= abort "read_graph_block: dynamic is corrupt"
		= read_graph_blocks (inc block_i) n_blocks {graph_blocks & [block_i] = graph_block} block_table dynamic_header file


// --------------------------------------------------------------------------------------------------------------------------			
:: *EncodedDynamic
	= { 
		ed_encoded_graph	:: !*{#Char}
	,	ed_dynamic_rts_info	:: !*{#Char}
	}
	
class EncodedDynamic a
where 
	dynamic_to_string :: !Dynamic -> (!Bool,!*a)

instance EncodedDynamic EncodedDynamic
where
	dynamic_to_string d
		#! d1 = d
		# (copy_graph_to_string,{ggtsf_o_n_library_instances=n_library_instances,ggtsf_o_range_table=range_table})
			= GetGraphToStringFunction
			
		# type_table_usage
			= (NF (createArray n_library_instances TTUT_UNUSED))	// indexed by RunTimeID or indirectly by converting a ModuleID to a RunTimeID

		#! cgtsa
			= { 
				cgtsa_dynamic					= d
			,	cgtsa_code_library_instances	= {} //createArray n_library_instances TTUT_UNUSED
			,	cgtsa_type_library_instances	= createArray n_library_instances TTUT_UNUSED
			,	cgtsa_range_table				= range_table
			}
		
		#! copy_graph_to_string_argument = /* NF */ {wrap_info = cgtsa}
		#! ({wrap_info = {cgtsr_encoded_dynamic,cgtsr_type_library_instances/*,cgtsr_code_library_instances*/,cgtsr_lazy_dynamic_references,cgtsr_runtime_ids}})
			= copy_graph_to_string copy_graph_to_string_argument
		
		#! gdri
			= {
				gdri_i_type_library_instances		= cgtsr_type_library_instances
			,	gdri_i_lazy_dynamics_references		= cgtsr_lazy_dynamic_references
			,	gdri_i_runtime_ids					= cgtsr_runtime_ids
			}
		#! dynamic_rts_info
			= GetDynamicRTSInfo	gdri

		# encoded_dynamic1
			= {
				ed_encoded_graph	= cgtsr_encoded_dynamic
			,	ed_dynamic_rts_info	= dynamic_rts_info
			}
		= (True,encoded_dynamic1)
	where 
		encode_type_table_usage :: !*{#Int} -> !*{#Char}
		encode_type_table_usage type_table_usage
			#! encoded_type_table_usage
				= createArray (s_type_table_usage << 2) ' '
			= encode_type_table_usage 0 0 encoded_type_table_usage
		where
			encode_type_table_usage i offset encoded_type_table_usage
				| i == s_type_table_usage
					= encoded_type_table_usage
					
					# encoded_type_table_usage
						= WriteLong encoded_type_table_usage offset type_table_usage.[i]
					= encode_type_table_usage (inc i) (offset + 4) encoded_type_table_usage
		
			s_type_table_usage
				= size type_table_usage
		
instance EncodedDynamic String
where
	dynamic_to_string d
		# (ok,{ed_encoded_graph,ed_dynamic_rts_info})
			= dynamic_to_string d
			
		// size of arrays
		# (s_ed_encoded_graph,ed_encoded_graph)
			= usize ed_encoded_graph
		# (s_ed_dynamic_rts_info,ed_dynamic_rts_info)
			= usize ed_dynamic_rts_info
		# s_encoded_dynamic
			= s_ed_encoded_graph + s_ed_dynamic_rts_info
			
		// copy
		# (j,encoded_dynamic)
			= copy 0 s_ed_encoded_graph ed_encoded_graph 0 (createArray s_encoded_dynamic ' ')
			
		# (_,encoded_dynamic)
			= copy 0 s_ed_dynamic_rts_info ed_dynamic_rts_info j encoded_dynamic
			
		// patch encoded dynamic
		# encoded_dynamic
			= WriteLong encoded_dynamic (DYNAMIC_RTS_INFO_OFFSET - HEADER_SIZE_OFFSET) s_ed_encoded_graph
		# encoded_dynamic
			= WriteLong encoded_dynamic (DYNAMIC_RTS_INFO_SIZE - HEADER_SIZE_OFFSET) s_ed_dynamic_rts_info
		= (ok,encoded_dynamic)
	where 
		copy :: !Int !Int !{#Char} !Int !*{#Char} -> (!Int,!*{#Char})
		copy i limit src j dest
			| i == limit
				= (j,dest)
			= copy (inc i) limit src (inc j) {dest & [j] = src.[i]}

string_to_dynamic :: !String -> (!Bool,!Dynamic)
string_to_dynamic dynamic_as_string
	#! (odtl=:{odtl_o_ok})
		= OpenDynamicToLinker dynamic_as_string
	| not odtl_o_ok
		= abort "string_to_dynamic: error communicating with linker"

	# (file,{odtl_o_dynamic_rts_string=dynamic_rts_string})
		= extract_file_from_odtl odtl

	# (ok,dynamic_header,file)
		= read_dynamic_header file
	| not ok
		= abort "readDynamic"
	
	#! (ok,gdid,file)
		= init_dynamic "string_to_dynamic" dynamic_header file
	| not ok
		= abort "_SystemDynamic; internal error"

	#! dyn
//		= build_dynamic make_start_node_index { gdid & gdid.di_dummy = dynamic_rts_string}
		= build_block (NF make_start_node_index) (NF { gdid & gdid.di_dummy = dynamic_rts_string})


	| CloseDynamicToLinker {odtl & odtl_o_file = file}
	= (ok,dyn)
where
	extract_file_from_odtl odtl=:{odtl_o_file}
		= (odtl_o_file,{odtl & odtl_o_file = (default_elem,default_elemU)})
	
// --------------------------------------------------------------------------------------------------------------------------			
:: Wrap a 
	= { 
		wrap_info		:: !a
	}

// aanpassen van gesharde type door alle library instanties		
:: *CopyGraphToStringArguments
	= {
		cgtsa_dynamic					:: Dynamic
	,	cgtsa_code_library_instances	:: !*{#Int}						// unused
	,	cgtsa_type_library_instances	:: !*{#Int}
	,	cgtsa_range_table				:: !{#Char}
	}
	
:: *CopyGraphToStringResults
	= {
		cgtsr_encoded_dynamic			:: !*{#Char}
	,	cgtsr_code_library_instances	:: !*{#T_ypeConsSymbolInfo}		// unused
	,	cgtsr_type_library_instances	:: !*{#Int}
	,	cgtsr_lazy_dynamic_references	:: !{#LazyDynamicReference}
	,	cgtsr_runtime_ids				:: !{#RunTimeIDW}
	}
	
:: T_ypeConsSymbolInfo
	= {
		tcsi_type_and_module_name		:: !String
	,	tcsi_rt_library_instance		:: !Int
	}
		
// --------------------------------------------------------------------------------------------------------------------------				
/*
** the dynamic to be decoded is identified by (encoded_graph_i,graph)
**
**
** ugid				= returned by the dynamic rts on readDynamic's behalf.
** ulid				= local id of dynamic (within ugid; 0 for a top-level dynamic)
** encoded_graph_i	= index of dynamic to be decoded (0 for a top-level dynamic)
** graph			= string encoding of the *complete* dynamic to be decoded
*/

// change also string_to_graph.c; gts_gdi.c
:: GlobalDynamicInfo = {
	// general
		file_name						:: !String
	,	first_time						:: !Bool

	// block table 
	,	id								:: !Int				// id from Dynamic Linker
	,	block_table						:: !BlockTable		
	,	graph_blocks					:: !{String}		// filepointer to start of graph
	,	graph_pointers					:: !{#.{Int}}
	
	// 
	,	diskid_to_runtimeid				:: !{#Int}			// conversion from DiskId (disguished as RunTimeId) to *real* runtimeID (library instances)
	,	di_disk_to_rt_dynamic_indices	:: !{#Int} 			// conversion from disk to runtime index for lazy dynamics
	,	di_dummy						:: !String
	,	di_type_redirection_table		:: !{#RunTimeIDW}
	}
// The # above ensure that no ARRAY node is inserted.
	
// to prevent the unboxing of GlobalDynamicInfo
:: GlobalDynamicInfoDummy = {
		gdid			:: !GlobalDynamicInfo
	}

is_block_i_already_present block_i gdid=:{gdid={graph_pointers}}
	= size graph_pointers.[block_i] <> 0

:: Pointer = Pointer

GetBlockAddresses node_index gdid=:{gdid={id,first_time,file_name,block_table,graph_blocks,di_dummy=dynamic_rts_string}}
	#! gba_in
		= { default_elem &
			gba_i_filename				= file_name
		,	gba_i_first_time			= first_time
		,	gba_i_id					= id
		,	gba_i_block_i				= block_i
		,	gba_i_dynamic_rts_string	= dynamic_rts_string
		}
		
	#! (copy_string_to_graph,{gba_o_diskid_to_runtimeid,gba_o_disk_to_rt_dynamic_indices,gba_o_id,gba_o_addresses,gba_o_rt_type_redirection_table})
		= GetBlockAddresses2 gba_in;
	#! gdid
		= case first_time of
			True
				#! gdid
					= { gdid &
						gdid	=  { gdid.gdid &
									first_time						= False
								,	id								= gba_o_id
								,	diskid_to_runtimeid 			= gba_o_diskid_to_runtimeid
								,	di_disk_to_rt_dynamic_indices	= gba_o_disk_to_rt_dynamic_indices
								,	di_type_redirection_table		= gba_o_rt_type_redirection_table
								}
					}
				-> gdid
			False
				-> gdid

	= (copy_string_to_graph,gba_o_addresses,gdid)
where
	block_i
		= get_block_i node_index

/*
build_dynamic :: !Int !GlobalDynamicInfoDummy -> a //Dynamic
build_dynamic node_index gdid=:{gdid={id,first_time,file_name,block_table,graph_blocks,di_dummy=dynamic_rts_string,di_type_redirection_table}} //dynamic_rts_string
	#! (copy_string_to_graph,s_adr,gdid)
		= GetBlockAddresses node_index gdid;

	#! graph_block
		= graph_blocks.[block_i]

	# bk_entries
		= if (size (block_table.[block_i].bk_entries) == 0) 
			{block_table.[block_i].bk_offset - block_table.[block_i].bk_offset}	// and block_table.[block_i].bk_n_node_entries == 0
			(to_help_the_type_checker { en_offset - block_table.[block_i].bk_offset \\ en_offset <-: block_table.[block_i].bk_entries })		

	#! (graph2,_)
		= copy_string_to_graph 
			(s_adr % (8,size s_adr)) 			// %edx
			0									// %ebx offset in graph_block 
			graph_block							// %ecx graph
			gdid								// -4(%esi) unboxed GlobalDynamicInfo
			bk_entries 							// -8(%esi)
			block_i 							// %eax
			en_node_i							// (%esp)
		
		// netter zou zijn om de graph_pointers uniek te maken
	= graph2
where
	block_i
		= 0
	en_node_i
		= 0
	block
		= block_table.[block_i]
	
	s 
		= ">> block_i: " +++ toString block_i +++ "  en_node_i:" +++ toString en_node_i
*/
// calling convention:
// must be in a strict context and its arguments must have been evaluated completely using NF.	
build_block :: !Int !GlobalDynamicInfoDummy -> a //Pointer
build_block node_index gdid=:{gdid={id,first_time,file_name,block_table,graph_blocks,graph_pointers}}
//	| True <<- ("build_block", block_i)
//		= undef;
//	| first_time //<<- ("build_block", block_i)
//		= abort "dfkkdfk";
	| is_external_entry_node node_index 
		= abort ("build_block: internal error" +++ toString node_index)
	| not first_time && is_block_i_already_present block_i gdid // <<- ("block_i", block_i, "en-node", en_node_i, "size", size graph_pointers.[block_i])
	
	
	// is_block_i_already_present block_i gdid=:{gdid={graph_pointers}}
	// 	= size graph_pointers.[block_i] <> 0
 
		// blocku has already been constructed
		// There are multiple references from some decoded i.e. built block to some unbuilt 
		// i.e. undecoded block. If one of these references is evaluated, then the undecoded
		// block will be constructed.		
		= extract_already_built_graph block_i en_node_i gdid

	#! (copy_string_to_graph,s_adr,gdid)
		= GetBlockAddresses node_index gdid;
//	| COLLECT_AND_RENUMBER_EXTERNAL_TYPE_REFERENCES (size gdid.gdid.GlobalDynamicInfo.di_type_redirection_table <= 0) False
//		= abort ("build_dynamic; di_type_redirection_table should contain entries because otherwise the dynamic would be untyped")
		

	// fetch graph (semantics problem: not referentially transparent if dynamics are to be overwritten)
	// In the near future blocks may be read lazily from disk. This creates other problems because the
	// dynamic cannot be overwritten if there are still references to its encoded graph. Also if copied
	// dynamics are supported, then it is the same problem.
	#! graph_block
		= graph_blocks.[block_i]
//	|  H ("@building block " +++ toString block_i) True
	
	// build graph
	// - for the time being it assumed that each block only has one entry
	//   node
	// - should create a unique array containg pointers to already built blocks. 
	// en-nodes

	// copy_string_to_graph
	// input:
	// - entry node needed
	// - offsets to be update din the the graph_pointers table
	
	// output:
	// - graph belong to entry node
	// (- destructively updated graph_pointers table)
	# bk_entries
		= if (size (block_table.[block_i].bk_entries) == 0) 
			{block_table.[block_i].bk_offset - block_table.[block_i].bk_offset}	// and block_table.[block_i].bk_n_node_entries == 0
			(to_help_the_type_checker { en_offset - block_table.[block_i].bk_offset \\ en_offset <-: block_table.[block_i].bk_entries })		

	# (graph2,_)
		= copy_string_to_graph 
			(s_adr % (8,size s_adr)) 			// %edx
			0									// %ebx offset in graph_block 
			graph_block							// %ecx graph
			gdid								// -4(%esi) unboxed GlobalDynamicInfo
			bk_entries 							// -8(%esi)
			block_i 							// %eax
			en_node_i							// (%esp)

		// netter zou zijn om de graph_pointers uniek te maken
	= graph2
where
	block_i
		= get_block_i node_index
	en_node_i
		= get_en_node_i node_index
	block
		= block_table.[block_i]
	
	s 
		= ">> block_i: " +++ toString block_i +++ "  en_node_i:" +++ toString en_node_i
		
	// Ideas:
	// - If there are no references more to a particular block and not all blocks have been built, then there is
	//   a space leak because the graph_pointers-array still contains pointers to at least one entry node.
	// - Version information per block instead per dynamic. In case of a copied dynamic i.e. a reference to a
	//   piece of graph in another dynamic, another version of the string_to_graph-routine might have been used.
	//   This version of the conversion routine should then be called.
	// - Reading blocks lazily. The dynamic run-time system must guarantee that the dynamic from which the blocks
	//   are lazily read remains available until there are no references to that dynamic or all blocks have been
	//   read from the dynamic.
	// - If during building a block some external node i.e. in an another block is referenced more than once, then
	//   the build_block-closure is built multiple times. This could be optimized.
	// - Can internal entry nodes occur in absence of existential types?
	//
	// The function below with its local function should *not* call the garbage collector because the pointer to
	// an already existing piece of graph can change because of gc.
	extract_already_built_graph :: !Int !Int !GlobalDynamicInfoDummy -> a //Pointer
	extract_already_built_graph block_i en_node_i gdid=:{gdid={graph_pointers}}
		#! (p,graph_pointers) 
			= graph_pointers![block_i,en_node_i]
		# (g,_) 
			= convert_to_dynamic p
		= g
	where
		convert_to_dynamic :: Int -> (a /*Pointer*/,!Int)
		convert_to_dynamic _
			= code {
					pushI	0
			}

build_lazy_block :: !Int !Int -> a //Pointer
build_lazy_block node_index lazy_dynamic_index
	| is_internal_reference node_index
		= abort "build_lazy_block; internal error; internal reference"
	#! debug_string
		= "external reference to block " +++ toString (get_block_i node_index) +++ " with entry node " +++ toString (get_en_node_i node_index) +++ " with lazy dynamic index " +++ (toString lazy_dynamic_index)

	#! rld_o
		= RegisterLazyDynamic lazy_dynamic_index;
	#! (rld_o_file,{rld_o_filename,rld_o_diskid_to_runtimeid,rld_o_disk_to_rt_dynamic_indices,rld_o_id,rld_o_rt_type_redirection_table})
		= extract_rld_o_file rld_o;

	# (ok,dynamic_header,rld_o_file)
		= read_dynamic_header rld_o_file
		
	# (ok,gdid,rld_o_file)
		= init_dynamic rld_o_filename dynamic_header rld_o_file
	| not ok
		= abort "init_dynamic: init_dynamic failed"

	#! gdid
		= { gdid &
			gdid	=  { gdid.gdid &
						first_time						= False
					,	id								= rld_o_id
					,	diskid_to_runtimeid 			= rld_o_diskid_to_runtimeid
					,	di_disk_to_rt_dynamic_indices	= rld_o_disk_to_rt_dynamic_indices
					,	di_type_redirection_table		= rld_o_rt_type_redirection_table
					}
		}
	= build_block (NF node_index) (NF gdid)
where
	extract_rld_o_file rld_o=:{rld_o_file}
		= (rld_o_file,{rld_o & rld_o_file = (0,default_elemU)})


copy_graph_to_string_OK :: !(Wrap CopyGraphToStringArguments) -> !(Wrap CopyGraphToStringResults)
copy_graph_to_string_OK _ 
	= {wrap_info={cgtsr_encoded_dynamic={},cgtsr_code_library_instances={},cgtsr_type_library_instances={},cgtsr_lazy_dynamic_references={},cgtsr_runtime_ids={}}}

to_help_the_type_checker i :== to_help_the_type_checker2 i
where
	to_help_the_type_checker2 :: !{#Int} -> !{#Int}
	to_help_the_type_checker2 i
		= i	